from datetime import datetime
import json
from jose import jwt
from hashlib import md5
import requests

from dotenv import load_dotenv
import os

load_dotenv()

api_key = os.environ.get("API_KEY")

# api_key = '<<SUA API KEY>>'

def create_encoded_header(endpoint, body, method):
    client_private_key = '''-----BEGIN EC PRIVATE KEY-----
    <<SUA PRIVATE KEY>>
    -----END EC PRIVATE KEY-----'''

    today_str = datetime.utcnow().strftime("%Y-%m-%dT%H:%M:%S")

    dict_to_sign = {"timestamp": today_str, "method": method, "uri": endpoint}

    body_bytes = json.dumps(body).encode()

    md5_instance = md5()
    md5_instance.update(body_bytes)
    md5_body = md5_instance.hexdigest()


    dict_to_sign["payload_md5"] = md5_body

    jwt_headers = {"alg": "ES512", "typ": "JWT"}
    encoded_header_token = jwt.encode(
        claims=dict_to_sign,
        key=client_private_key,
        algorithm="ES512",
        headers=jwt_headers,
    )
    return encoded_header_token

FUND_CLASS_KEY = ''

base_url = "https://manager-api.sandbox.qidtvm.com.br"
endpoint = f"/trade_security/fund_class/{FUND_CLASS_KEY}/integralization"
method = "POST"

body = {
 "security_external_id": "a23c006c-befd-40e0-bc3d-fbd2dfbbea5d",
 "bookkeeper_document_number": "00.000.000/0000-00",
 "security_key": "272a394a-e3d0-4484-b00e-e18a4e22bb5e",
 "unit_price": "2.00",
 "number_of_units": "100.00",
 "external_id": "90b679c0-2674-4cad-917a-5c786b0bf992",
 "integralization_date": "2025-05-27",
 "payment": {
   "target_account": {
    "account_branch": "0001",
    "account_digit": "0",
    "account_number": "12345",
    "financial_institution_code": "329",
    "financial_institution_ispb": "32402502"
   }
  }
}

encoded_header_token = create_encoded_header(endpoint, body, method=method)

headers = {"API-CLIENT-KEY": api_key, "AUTHORIZATION": encoded_header_token}

url = f"{base_url}{endpoint}"

resp = requests.post(url=url, headers=headers, json=body)
print(resp.json())

